<?php 
	use Elementor\Icons_Manager;
   use Elementor\Group_Control_Image_Size;
	$has_icon = !empty($item['selected_icon']['value']);
   $active = $item['active'] == 'yes' ? ' active' : '';
   $last_style = $settings['last_style'] ? ' last-style' : '';
?>

<?php 
if($settings['style'] == 'style-1'){ 

	$image_id = $item['image']['id']; 
   $image_url = isset($item['image']['url']) ? $item['image']['url'] : '';
   if($image_id){
      $attach_url = Group_Control_Image_Size::get_attachment_image_src($image_id, 'image', $settings);
      if($attach_url){
         $image_url = $attach_url;
      }
   }

   $svg = '
      <svg viewBox="0 0 79 80" fill="none" xmlns="http://www.w3.org/2000/svg">
         <g clip-path="url(#clip0_24_1239)">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M52.7764 68.9061C52.4167 69.2775 53.0865 68.8856 53.1857 69.102C54.0829 68.502 54.7981 68.3305 54.7237 68.0612C54.1904 68.453 53.9133 68.5387 53.6694 68.5918C53.4213 68.6489 53.2064 68.6693 52.7764 68.9061Z" fill="#fff"/>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M60.8965 63.1224C60.1606 63.9102 59.3833 64.6245 58.945 64.7633C59.5239 64.2082 58.9285 64.3796 59.4949 63.8245C60.1192 63.5265 60.7973 63.1429 61.7358 62.0816C61.066 62.7347 61.2934 61.9551 60.9048 62.2367C60.5616 62.4816 60.0365 62.9551 59.4164 63.5225C58.7962 64.0898 58.0727 64.7429 57.3533 65.3673C55.9227 66.6245 54.4922 67.7388 54.2938 68.1633C55.7491 67.4612 57.3491 66.4204 58.8334 65.1796C60.3259 63.9429 61.6944 62.5102 62.8066 61.1306C62.3436 61.4776 61.6407 62.3388 60.8965 63.1224ZM56.9274 66.4245C56.3775 66.7714 55.8235 67.0327 55.6002 67.0082C56.5925 66.3429 56.5305 66.1673 57.4856 65.4531C57.3326 66.0163 57.4566 65.7102 58.2463 65.3918C58.0189 65.6449 57.4773 66.0776 56.9274 66.4245Z" fill="#fff"/>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M78.2322 41.2285C78.2322 40.7632 78.2157 40.6367 78.1784 40.1387C78.1206 39.4408 78.0875 38.7795 78.0089 38.1673C77.9056 37.3918 77.8642 37.0979 77.7898 36.6653C77.765 36.5306 77.7774 36.3999 77.7815 36.4204C77.6989 35.9795 77.6534 36.0285 77.6492 35.7959C77.6492 35.7346 77.5665 35.4612 77.5541 35.3795C77.55 35.351 77.5872 35.3673 77.5872 35.3428C77.5872 35.302 77.5128 35.0163 77.4921 34.9387C77.5004 34.7673 77.4508 34.1265 77.5459 34.2244C77.7361 34.4652 77.7361 34.4204 77.9221 34.3469C77.918 33.5387 77.7609 32.6979 77.6575 32.0081C77.5417 31.2489 77.5789 31.3387 77.5128 31.1755C77.3267 30.7346 77.3722 30.3959 77.2606 29.9346C77.1696 29.7755 77.0952 29.8693 77.0043 29.7101C76.9588 29.1632 76.9381 29.0897 76.7562 28.6897C76.5495 28.5877 76.6404 29.6081 76.4048 29.1061C76.3386 28.8408 76.413 28.8571 76.3676 28.6285C76.3179 28.3959 76.3179 28.2734 76.3221 28.151L76.5081 27.9183C76.38 27.2938 76.198 26.5999 75.9458 25.8367C75.6936 25.9469 75.2513 24.8693 74.7675 23.9469C74.6435 23.1142 75.1975 24.1102 75.2388 23.5142C75.1107 23.2653 75.1438 23.0612 75.0693 22.804C74.9618 22.4326 74.6269 21.6816 74.2052 20.8612C73.7835 20.0367 73.2708 19.1469 72.8698 18.4571C72.7623 18.2693 72.7582 18.2122 72.6713 18.053C72.5515 17.8367 72.3571 17.5428 72.2207 17.3387C72.0098 17.0204 71.8982 16.9877 71.7204 16.7306C71.5674 16.5142 71.5798 16.4244 71.3773 16.1632C71.1705 15.9224 71.3277 16.4285 70.9473 15.8367C70.724 15.5142 70.9225 15.5755 70.7612 15.3102C70.2775 14.6775 70.3395 14.951 69.9385 14.502C70.0129 14.5836 69.864 14.3469 69.8186 14.2897C69.6904 14.1224 69.6491 14.1387 69.5416 14.0122C69.5043 14.1346 69.5374 14.3795 69.1984 13.9755C68.5286 13.1428 68.5865 12.8816 68.6568 12.6122C68.5452 12.4081 68.2805 12.204 68.0862 11.9918C67.8547 11.7346 67.5818 11.351 67.218 11.0367C66.9658 10.9061 67.0609 11.2571 66.85 11.1795C67.0402 11.4204 67.3875 11.7755 67.4082 11.9183C66.9575 11.4612 66.8996 11.5877 66.6433 11.3714C66.4697 11.2204 66.234 10.951 66.0521 10.7959C65.928 10.8448 65.8288 10.9183 65.403 10.5714C65.097 10.253 64.39 9.73464 64.3321 9.57137C64.4727 9.38362 64.7415 9.32648 65.4898 9.89382C65.5559 9.75913 65.5022 9.55505 65.3782 9.31423C65.2583 9.19586 65.0681 9.04076 65.0639 8.9877C64.3404 8.39586 63.9559 8.22852 63.2613 7.73056C62.6701 7.31015 62.8561 7.24484 62.2525 6.83668C61.9796 6.7877 61.5042 6.59586 61.9135 7.08566C61.5745 6.89791 61.1817 6.66525 61.0618 6.69382C61.376 6.96729 61.1693 6.8775 61.4049 7.1224C61.4835 7.19995 62.1533 7.66933 61.9094 7.62444C61.1693 7.02852 60.6814 6.73872 59.8628 6.25301C59.5775 6.13872 59.8215 6.48974 59.532 6.37954C59.0111 5.96321 58.7341 5.9428 58.3082 5.70607C57.9816 5.5224 57.8576 5.3877 57.4111 5.16729C57.1795 5.11831 56.8653 4.97546 56.5263 4.84893C56.2534 4.74689 55.9805 4.70607 55.4472 4.42035L55.3934 4.13464C55.9599 4.33872 56.547 4.56729 57.3904 5.02444C57.8162 5.08566 58.7465 5.56321 59.3212 5.7877C59.3749 5.6775 59.3129 5.48974 59.4618 5.45301C59.5693 5.42852 59.7718 5.5428 59.8049 5.47342C59.8421 5.39178 59.8669 5.30199 59.5982 5.02444C58.8953 4.71423 58.2545 4.26117 57.7625 4.00403C57.5723 3.90607 57.5475 3.93056 57.3987 3.86117C56.6214 3.51015 56.2948 3.29791 55.6829 2.99995C55.4431 2.96321 54.8436 2.70199 54.5624 2.64893C53.9422 2.37954 53.9009 2.45709 53.2104 2.16729C52.5283 2.03668 52.8094 2.44484 52.6275 2.59178C51.8668 2.37954 51.6683 2.41627 50.705 2.04893C50.738 2.22035 50.151 2.20811 49.8698 2.18362C49.8119 2.17954 49.936 2.26933 49.9029 2.27342C49.8533 2.28158 49.6093 2.25301 49.5473 2.26117C49.4067 2.28158 49.4688 2.39995 49.0305 2.28974C48.6005 2.08158 48.2284 2.16729 48.0176 1.96729C48.2119 1.81219 48.9437 1.8775 49.6093 1.94689C49.6135 1.75913 50.4362 1.79178 49.9856 1.51423C49.4564 1.32648 49.0884 1.40811 48.7866 1.20811C48.3483 0.848926 49.5142 1.16729 49.1876 0.857089C48.3235 0.604028 47.6083 0.485661 46.8806 0.375457C46.1529 0.269334 45.4129 0.171375 44.4743 0.00402832C44.4537 0.101987 43.9327 0.0652528 43.9989 0.191783C43.6392 0.150967 43.3663 0.138722 43.2009 0.155049C43.4242 0.297906 42.9198 0.248926 43.1472 0.391783C42.312 0.38362 42.5105 0.6326 41.7497 0.65709C41.2371 0.58362 41.3776 0.644845 40.7078 0.58362C40.6748 0.514232 40.5797 0.45709 40.3936 0.420355C39.7693 0.436681 39.5585 0.363212 39.1161 0.346885C38.9879 0.15913 38.1693 0.15913 37.822 0.040763C37.1357 0.0489263 37.4788 0.167294 37.0943 0.20811C36.8711 0.134641 35.9367 0.289743 35.4323 0.330559C35.2917 0.375457 35.4364 0.416273 35.3289 0.461171C35.2834 0.477498 34.9734 0.493824 34.9237 0.514232C34.7294 0.587702 34.7294 0.653008 34.4565 0.734641C33.6834 0.636681 33.3485 1.05709 32.6911 1.0775C32.2487 1.08974 32.7449 0.991783 32.5134 0.910151C31.5624 1.10199 30.2931 1.37954 30.0161 1.58362C30.0161 1.77138 30.5536 1.66933 30.7438 1.76321C30.7603 1.9224 30.5867 2.09791 30.7976 2.24076C30.5453 2.31831 30.5205 2.37546 30.2973 2.45709C30.0947 2.53056 29.7474 2.59587 29.5365 2.67342C29.4042 2.7224 29.4456 2.81627 29.0445 2.90607C28.5277 2.7877 29.334 2.50199 28.8874 2.37138C29.0239 2.28566 29.582 2.14689 29.3505 2.10607C29.4166 1.99178 29.3877 1.95913 29.2347 1.80811C28.9329 1.84893 28.8089 1.93056 28.4616 2.04484C28.1432 2.15097 27.643 2.30199 27.3122 2.4326C27.0269 2.5428 26.7168 2.71831 26.4481 2.84076C25.7659 3.13872 24.7199 3.60811 24.5297 3.77546C24.4966 3.80403 24.2238 3.90607 24.1659 3.9428C24.0749 3.99995 23.9964 4.09791 23.8889 4.16321C23.5622 4.36729 23.2067 4.50607 23.0785 4.65301C22.7808 4.80403 22.4873 4.95913 22.1979 5.11831C22.1317 5.27342 22.2558 5.36321 22.4583 5.42852C22.1193 5.66117 21.6687 5.94689 21.3917 6.16729C21.5446 6.2326 21.3917 6.41219 21.1973 6.60811C20.9823 6.73872 20.9121 6.72239 20.6557 6.89382C20.573 7.0326 20.3953 7.2326 20.3456 7.28158C20.2423 7.38362 20.6764 7.27342 20.3622 7.46117C20.0397 7.67342 20.0356 7.54689 19.6304 7.85301C19.9859 7.82035 19.5063 8.15913 19.4733 8.30199C19.097 8.57137 18.9317 8.74689 18.7291 8.9428C18.5265 9.13872 18.2908 9.35097 17.7823 9.72239C17.5797 9.8326 17.1497 9.87342 17.4143 9.60811C17.7947 9.28566 17.7079 9.56729 18.1544 9.17546C18.3198 8.89791 18.3446 8.68974 18.6671 8.3428C18.9523 8.09791 19.1466 7.84076 19.5684 7.65709C19.4815 7.62035 19.833 7.33872 20.11 7.11015C20.387 6.88158 20.5937 6.71015 20.1844 6.86525C20.4201 6.81219 19.9611 7.22035 19.7834 7.22444C19.8247 7.0775 20.325 6.74689 19.9611 6.77546C18.8903 7.4775 18.0386 8.16321 17.3895 8.76729C17.6086 8.75505 17.3854 8.97546 17.1621 9.20403C16.5543 9.76321 16.2691 10.151 15.4463 10.902C15.3802 11.1795 14.4912 12.0326 14.8096 12.0653C14.5698 12.2979 14.4044 12.4897 14.3217 12.6163C14.3631 12.6489 14.3589 12.7183 14.3548 12.7877C13.7843 13.2489 13.5031 13.5142 13.0525 13.8775C12.978 13.9959 12.8457 14.155 12.7258 14.3102C11.6013 15.3959 10.5511 16.5632 9.57951 17.7999C9.55057 17.7755 9.50095 17.7591 9.42653 17.7306C8.85184 18.302 8.35571 19.0081 7.93813 19.5673C7.47507 20.1836 7.51228 20.0979 7.44199 20.253C7.26008 20.6938 6.98307 20.902 6.73087 21.3061C6.67712 21.4816 6.80115 21.4693 6.74741 21.6448C6.38771 22.0653 6.34636 22.1306 6.18925 22.5387C6.2182 22.6244 6.34636 22.551 6.4704 22.4612C6.32983 22.7142 6.19752 22.9714 6.06522 23.2285L5.81302 23.2571C5.45332 23.7877 5.08535 24.404 4.71739 25.1183C4.97372 25.2163 4.5148 26.2897 4.19231 27.2775C3.68377 27.955 4.00626 26.8652 3.54733 27.253C3.45638 27.5183 3.291 27.6408 3.1587 27.8734C3.01399 28.1346 2.799 28.653 2.57574 29.2775C2.51372 28.9959 2.38142 28.8979 2.37728 28.4816C2.58814 27.6489 2.53439 27.4897 2.75765 26.7183C2.98505 26.4775 3.03466 26.4612 3.1711 26.5673C3.27446 26.2938 3.36955 26.1714 3.46465 26.1142C3.75406 25.1755 3.96905 24.3877 4.275 23.6285C4.59335 22.8326 5.06468 22.053 5.23419 21.3714C5.40784 21.0571 5.57322 20.853 5.80475 20.4285C5.74273 20.5387 5.82956 20.2897 5.84609 20.253C5.94946 20.0081 6.08176 19.853 6.16445 19.702C6.54895 19.0489 6.61097 18.751 6.87971 18.2857C7.0947 17.9224 7.39652 17.551 7.59497 17.2326C7.72727 17.0204 7.89265 16.8285 7.96707 16.7142C8.03322 16.6081 8.04149 16.5265 8.02495 16.5469C8.13658 16.3714 8.20273 16.3469 8.29369 16.2081C8.71954 15.5755 9.08751 15.102 9.26529 14.8775C9.52163 14.5591 9.60845 14.3959 9.79864 14.2326C10.0384 14.0244 10.3403 13.4897 10.6007 13.2816C10.6462 13.2448 10.8033 13.0244 10.8571 12.9714C10.8736 12.955 10.8901 12.9877 10.9067 12.9755C11.1465 12.7795 11.6261 12.0734 11.7873 11.902C11.7088 11.9877 11.9651 11.7469 12.1966 11.5142C12.4323 11.2816 12.6431 11.0571 12.4778 11.1591C12.1346 11.6326 11.9486 11.5755 11.5062 12.0367C11.531 12.0081 11.4069 12.2653 11.3367 12.351C11.3904 12.2857 11.1961 12.453 11.1547 12.502C11.072 12.5918 10.977 12.7265 10.8943 12.8081C10.7082 12.9959 10.6131 13.0326 10.3568 13.2693C10.1501 13.4571 9.84412 13.8244 9.75316 13.902C9.65806 13.9877 9.89373 13.555 9.5299 14.0612C9.41413 14.0979 9.20327 14.3387 8.9428 14.7142C8.48801 15.3591 8.90559 15.0734 8.59964 15.5428C8.11591 16.0326 8.703 15.1469 8.32263 15.3836C8.4384 15.2163 8.5583 15.0489 8.67406 14.8816C8.06216 15.0816 6.8673 16.7061 5.85023 18.5795C5.58976 18.8285 5.21766 19.5387 4.98613 19.7265C4.5272 20.6979 4.23365 20.9795 3.82021 22.0244C3.72925 22.0857 3.61349 22.3632 3.52253 22.4448C3.31994 23.0081 2.98918 23.7224 2.92303 23.8367C2.88582 23.8979 2.70804 24.3673 2.6791 24.4408C2.48891 24.8489 2.4393 25.1306 2.26152 25.653C2.25325 25.6816 2.20777 25.7224 2.15816 25.8693C2.0672 26.1428 2.02172 26.3102 1.9473 26.4897C1.78606 26.8489 1.67029 27.4285 1.55453 27.9265C1.49664 27.951 1.47597 28.1632 1.42222 28.351C1.36434 28.551 1.28579 28.6734 1.24858 28.804C1.18656 29.0204 1.07079 29.5918 1.01705 29.853C0.921954 30.2979 0.83513 30.6612 0.785516 31.1142C0.616004 31.6326 0.463029 32.4367 0.37207 33.1101L0.22323 34.2081C0.214961 34.2612 0.214961 34.3632 0.214961 34.4204C0.194289 34.7224 0.115734 34.8204 0.107465 35.102C0.0991962 35.3102 0.0661206 35.2653 0.0619861 35.3387C0.00823816 36.0367 0.0537172 36.2979 0.0206415 36.6285C-0.0124341 36.9918 0.0123726 36.951 0.0371794 37.2612C0.0867929 37.8408 0.0330449 37.902 0.0454483 38.3428C0.0619861 38.7632 0.0950618 38.9755 0.0661206 39.2122C0.0330449 39.4734 0.152944 40.1061 0.070255 40.1183C0.0991962 40.4979 0.190154 41.0163 0.22323 41.3714C0.227364 41.4326 0.202558 41.7591 0.210827 41.8571C0.235633 42.1142 0.322457 42.4408 0.347264 42.6897C0.355533 42.7877 0.347264 43.0571 0.355533 43.1755C0.372071 43.4163 0.421684 43.702 0.413415 43.8693C0.41755 43.8938 0.421684 43.9142 0.425818 43.9387C0.388608 44.0081 0.355533 44.0816 0.326591 44.1673C0.326591 44.3346 0.351398 44.5795 0.314188 44.6163C0.401012 45.5428 0.549852 45.9265 0.686289 46.7673C0.802054 47.4775 0.624273 47.3959 0.756575 48.102C0.913685 48.3265 1.11214 48.7959 1.17416 48.1632C1.27752 48.5346 1.38915 48.9714 1.49251 49.0367C1.47184 48.6938 1.52145 48.7755 1.54626 48.6204C1.62068 48.8081 1.69096 48.9306 1.77365 49.1469C1.79019 49.2285 1.81086 49.3142 1.83153 49.3999C1.84807 49.5428 1.89355 49.7224 1.95557 49.9183C1.97624 50.0081 2.00105 50.0938 2.02172 50.1918C2.04239 50.2408 2.06306 50.2653 2.08374 50.2775C2.1995 50.5836 2.33594 50.902 2.44343 51.1755C2.58814 51.5428 2.71631 51.8938 2.84861 52.2285C2.87755 52.351 2.91063 52.4897 2.97265 52.6734C3.10081 52.8693 3.22071 53.1918 3.36955 53.5142C3.48945 53.7755 3.65483 53.9959 3.82434 54.5714L3.65483 54.8081C3.40263 54.2693 3.15043 53.6979 2.88169 52.7836C2.62535 52.4408 2.31113 51.4571 2.0672 50.8938C1.95143 50.9346 1.86048 51.1101 1.72817 51.0285C1.63721 50.9714 1.5752 50.7469 1.50078 50.7755C1.41809 50.8081 1.3354 50.853 1.32713 51.2367C1.6 51.9469 1.72404 52.7142 1.89355 53.2408C1.95557 53.4408 1.99278 53.4408 2.05066 53.5999C2.34834 54.3918 2.4269 54.7714 2.64189 55.404C2.78246 55.5959 3.02226 56.1999 3.1835 56.4367C3.42744 57.0571 3.51426 57.0367 3.79127 57.7224C4.17577 58.2897 4.27086 57.8081 4.50653 57.8285C4.89103 58.5101 5.05641 58.6244 5.47399 59.555C5.57322 59.4122 5.9784 59.8326 6.16031 60.0448C6.19752 60.0897 6.17685 59.9387 6.20166 59.9591C6.243 59.9877 6.39184 60.1795 6.44559 60.2204C6.55722 60.3061 6.59857 60.1755 6.83009 60.5591C6.9872 61.0081 7.30969 61.2081 7.31383 61.4938C7.06576 61.4693 6.59857 60.9102 6.17685 60.3959C6.04041 60.5265 5.48226 59.9265 5.60216 60.4408C5.84196 60.9428 6.15618 61.1428 6.2306 61.4938C6.28021 62.053 5.68898 61.0122 5.69312 61.4612C6.1231 62.2448 6.54068 62.8285 6.9748 63.4163C7.41305 63.9999 7.86371 64.5877 8.40532 65.3591C8.49215 65.302 8.83117 65.6979 8.87252 65.5591C9.09578 65.8408 9.28183 66.0408 9.41 66.1428C9.35211 65.8857 9.6746 66.2734 9.61672 66.0163C10.1997 66.6081 10.2369 66.2938 10.795 66.804C11.1051 67.2122 11.0472 67.0734 11.4772 67.5836C11.4483 67.6571 11.4772 67.7632 11.5806 67.9183C12.0312 68.3469 12.1263 68.5428 12.4323 68.8652C12.3868 69.0857 12.9656 69.6612 13.1227 69.9836C13.6106 70.4571 13.4576 70.1346 13.7553 70.3755C13.8587 70.5836 14.6318 71.1265 15.0163 71.4489C15.1445 71.5142 15.0742 71.3836 15.1858 71.4285C15.2313 71.4448 15.4587 71.653 15.5083 71.6734C15.7068 71.7591 15.7523 71.7102 16.0045 71.8408C16.4799 72.453 17.0174 72.3877 17.497 72.8326C17.8154 73.1306 17.3978 72.853 17.5011 73.0734C18.3115 73.604 19.403 74.2938 19.7461 74.3469C19.8826 74.2163 19.4278 73.9102 19.3616 73.7142C19.465 73.5918 19.7131 73.5877 19.6635 73.3387C19.8991 73.4612 19.957 73.4367 20.172 73.5387C20.3704 73.6285 20.6599 73.8285 20.8624 73.9183C20.9906 73.9755 21.0278 73.8816 21.3751 74.0979C21.6563 74.5428 20.879 74.1836 21.1022 74.5836C20.941 74.551 20.449 74.253 20.5854 74.4489C20.4573 74.4857 20.4531 74.5265 20.4531 74.7387C20.6929 74.9224 20.8418 74.9469 21.1725 75.1102C21.4702 75.2571 21.9333 75.502 22.264 75.6408C22.5452 75.7591 22.8883 75.8571 23.1653 75.9591C23.8599 76.2244 24.939 76.6244 25.1871 76.6408C25.2284 76.6448 25.4972 76.7632 25.5633 76.7755C25.6667 76.7999 25.7949 76.7836 25.9148 76.8163C26.291 76.902 26.6424 77.053 26.8367 77.0367C27.1551 77.1346 27.4734 77.2326 27.7918 77.3224C27.9489 77.2571 27.9241 77.1061 27.829 76.9224C28.2383 76.9959 28.7551 77.1102 29.1148 77.1428C29.0569 76.9918 29.2926 76.9714 29.5696 76.9673C29.8135 77.0244 29.8549 77.0857 30.1567 77.1428C30.3138 77.102 30.5826 77.0857 30.657 77.0857C30.8017 77.0857 30.4172 76.8612 30.7727 76.9469C31.149 77.0244 31.0663 77.1183 31.5707 77.1795C31.2937 76.955 31.8766 77.053 32.0048 76.9714C32.4637 77.0448 32.7077 77.0367 32.993 77.0408C33.2782 77.0448 33.5966 77.0571 34.2209 77.151C34.4441 77.2163 34.7749 77.4897 34.3987 77.4897C33.8984 77.4489 34.163 77.3102 33.5676 77.2775C33.2493 77.3591 33.088 77.4857 32.6084 77.5101C32.2322 77.4816 31.9097 77.5306 31.4797 77.3632C31.5169 77.453 31.0663 77.404 30.7066 77.3714C30.3469 77.3387 30.0782 77.3183 30.4792 77.4938C30.2725 77.3673 30.8926 77.3999 31.0167 77.5183C30.8844 77.5918 30.2931 77.4816 30.5702 77.7142C31.8312 77.9673 32.9227 78.0816 33.8157 78.1061C33.6545 77.9632 33.9687 77.9632 34.287 77.955C35.1181 77.9836 35.5977 77.9101 36.7181 77.955C36.962 77.804 38.2065 77.8244 38.0039 77.5755C38.3388 77.5755 38.5951 77.5591 38.744 77.5265C38.7274 77.3836 39.1078 77.3061 38.8515 77.1265C38.2892 76.9877 37.3796 76.9183 36.7346 76.7632C35.9987 76.7551 35.0933 76.6163 34.8162 76.5673C34.7666 76.5591 34.6798 76.555 34.6302 76.551C34.4193 76.5265 34.5227 76.5101 34.4235 76.4897C34.1341 76.4285 33.9232 76.3755 33.6379 76.3224C33.6999 76.3346 33.4353 76.3387 33.2865 76.3183C33.3072 76.3224 33.179 76.2693 33.0798 76.2489C32.8358 76.204 32.6705 76.1591 32.5051 76.1224C32.2363 76.0653 32.1247 76.0489 31.9345 75.9877C31.5004 75.853 31.0539 75.804 30.8017 75.6897C30.7521 75.6693 30.5081 75.6326 30.4379 75.6122C30.413 75.604 30.442 75.5755 30.4213 75.5673C30.38 75.5469 30.1236 75.502 30.0575 75.4857C29.7267 75.3836 29.2967 75.2816 28.9577 75.1673C28.9412 75.1632 28.9577 75.1306 28.9453 75.1224C28.8998 75.0979 28.6518 75.0489 28.5856 75.0244C28.5608 75.0163 28.5898 74.9877 28.5732 74.9795C28.35 74.8612 27.5231 74.7102 27.3287 74.5999L26.4068 74.1183C26.3034 74.0612 26.1918 73.9836 26.076 73.9224C26.1339 73.9387 26.1918 73.9591 26.2496 73.9755C26.7168 74.1551 27.0641 74.3183 27.5479 74.4734C27.7918 74.551 28.3996 74.6857 28.8047 74.7877C29.181 74.8857 29.3133 74.9469 29.6688 75.0204C30.0492 75.0979 30.1319 75.0653 30.4957 75.1469C30.7314 75.1959 30.6115 75.1959 30.7314 75.2285C31.1283 75.3387 31.364 75.3714 31.8188 75.453C32.3025 75.5387 32.7656 75.6204 33.2245 75.6938C33.8984 75.8979 35.0064 76.0081 36.1558 76.0408C36.1972 76.0408 36.2426 76.0408 36.284 76.0448C36.7388 76.0775 37.1646 76.102 37.5533 76.1142C38.4174 76.1428 38.8349 76.1306 39.3145 76.1306C40.0422 76.1265 40.1621 76.0897 40.4267 76.1142C40.5011 76.1224 40.836 76.0448 41.0427 76.0326C42.2872 75.9755 43.6226 75.951 44.5405 75.6857C45.6733 75.6448 47.2362 75.3795 48.9478 74.8979C49.477 74.7387 49.0884 74.6979 49.6135 74.5346C49.9773 74.4897 50.705 74.2285 51.2921 74.0244C51.5897 73.9999 51.3623 74.2571 52.3546 73.8857C52.5737 73.7836 52.7639 73.6775 52.8714 73.5959C52.7887 73.555 52.9169 73.4693 53.1402 73.3591C53.3428 73.2775 53.3428 73.2408 53.4957 73.1673C53.843 72.9999 54.1118 72.9306 54.3268 72.8489C54.6823 72.7102 54.765 72.653 54.9552 72.604C55.0007 72.7428 55.3976 72.6081 55.658 72.5755C56.4849 72.1673 57.0844 71.9265 57.994 71.3755C58.3951 71.1101 58.3413 71.0204 58.7341 70.751L58.8747 70.804C59.3625 70.5183 59.1269 70.5387 59.4618 70.2938C59.7842 70.0571 60.2142 69.8244 60.7104 69.4612C61.1486 69.253 61.4049 69.2449 61.7936 69.0775C61.9383 68.9795 62.1367 68.8244 62.1864 68.8326C62.7859 68.2897 63.3523 67.9836 63.8236 67.4734C64.4066 67.1224 64.5802 66.8408 65.2128 66.351C65.4484 66.0816 65.4774 65.9591 66.0479 65.4448C66.3622 65.155 66.3622 65.355 66.8004 64.8571C66.9451 64.6326 66.6226 64.7632 66.9947 64.3632C67.3875 63.9387 67.371 64.0571 67.5736 63.7346C67.5612 63.6448 67.6604 63.4122 67.6108 63.3959C67.5612 63.3795 67.6811 63.2938 67.7017 63.2326C67.801 62.9714 67.6025 63.2693 67.5033 63.2163C67.4619 63.1959 67.5942 63.0204 67.6811 62.8897C67.9663 62.5877 68.1358 62.4938 68.4625 62.0897C68.5576 61.9142 68.3219 62.0285 68.7105 61.5918C68.9669 61.3836 69.4837 60.5959 69.6325 60.5918C69.4051 60.9346 69.8516 60.6448 69.3224 61.2653C68.7891 62.0204 68.8139 61.6326 68.2433 62.4122C68.1193 62.6612 68.6113 62.2857 68.6899 62.4367C68.5534 62.6938 68.8263 62.5918 68.9545 62.6204C69.4671 61.9306 69.9633 61.3387 70.4057 60.7551C71.0754 59.8734 71.4393 59.204 71.7246 58.9836C72.1421 58.3469 71.9354 58.404 72.2083 57.9102C72.4812 57.4857 72.6176 57.204 72.7003 56.9959C72.6589 56.9755 72.5432 57.0448 72.6548 56.8285C72.4729 56.653 71.6625 57.5346 71.9685 56.7428C72.0967 56.6408 72.2496 56.4571 72.3737 56.351C72.6465 55.8734 72.3199 56.5918 72.5721 56.3265C72.8946 55.8693 73.1923 55.4775 73.4569 55.1591C73.2956 55.5142 73.3205 55.6163 73.0683 56.0857C73.3329 55.804 73.06 56.3836 73.0641 56.4285C73.0807 56.5795 73.0517 56.604 73.3122 56.3918C73.3701 56.2816 73.4362 56.1632 73.4982 56.0408C73.2378 56.6489 73.2915 56.7999 73.1882 57.1061C73.1179 57.3102 73.0269 57.3999 72.9153 57.6775C72.9401 57.6204 72.907 57.7877 72.8863 57.8489C72.8285 58.0163 72.7127 58.2367 72.6507 58.404C72.5845 58.9265 72.229 59.8204 71.5716 60.9224C71.0134 61.5142 70.6413 62.3265 69.9633 63.2244C69.7235 63.6244 69.8723 63.5999 69.7193 63.8938C69.5498 64.2081 69.3886 64.5101 69.1323 64.8979C68.9875 64.8938 68.694 65.2489 68.4831 65.3918C68.202 65.7714 67.9167 66.1469 67.6232 66.5183C67.4413 66.6857 67.404 66.5591 67.094 66.9795C66.6847 67.5632 66.2919 67.8775 65.9983 68.3632C65.9239 68.2204 65.5187 68.6612 65.2045 68.9224C65.1012 69.0979 65.2169 69.1142 65.3575 69.1102C65.6056 68.9346 66.0603 68.3877 66.1968 68.3836C65.7585 68.9346 65.2211 69.5183 64.8365 69.6979C65.035 69.3877 64.973 69.3306 64.6422 69.4979C63.9518 70.1551 63.8029 70.4203 63.1704 70.8897C63.0339 71.1142 62.6287 71.4938 62.4427 71.7346C62.174 71.8326 61.9094 72.2571 61.3347 72.6367C61.3471 72.8367 61.2354 73.1102 60.8261 73.5265C60.3341 73.7836 60.6897 73.4163 60.545 73.4367C60.4747 73.4489 59.8339 73.8612 60.0282 73.6163C60.0737 73.4938 60.1357 73.3591 60.0819 73.2857C59.6106 73.6367 59.47 73.6122 58.9904 73.951C58.8168 74.204 58.8499 74.3673 58.548 74.6693C57.7997 75.1061 57.7253 75.2571 57.0141 75.6489C56.6834 75.6571 56.6338 75.6367 56.6131 75.4652C56.3444 75.5877 56.1873 75.6081 56.0798 75.5795C55.1991 76.0408 54.4839 76.4448 53.7231 76.7673C52.9252 77.1061 52.0363 77.3265 51.4285 77.6897C51.0853 77.7918 50.8166 77.8163 50.3535 77.955C50.4734 77.9183 50.2378 78.0367 50.2006 78.0489C49.9525 78.151 49.7458 78.1673 49.5804 78.2122C48.8403 78.404 48.5799 78.5755 48.0589 78.7102C47.6455 78.8163 47.1659 78.8693 46.7979 78.955C46.5498 79.0122 46.2976 79.0326 46.1653 79.0612C46.0413 79.0897 45.9793 79.1428 46.0041 79.1387C45.8015 79.1836 45.7354 79.1551 45.57 79.1918C44.8134 79.3428 44.218 79.4203 43.9327 79.4489C43.5234 79.4979 43.3415 79.551 43.0934 79.5346C42.7751 79.5142 42.1797 79.6775 41.8448 79.6448C41.7869 79.6408 41.5182 79.6816 41.4396 79.6857C41.4148 79.6857 41.4314 79.653 41.4066 79.6489C41.0965 79.6163 40.2531 79.7795 40.0133 79.7918C40.129 79.7836 39.7776 79.7795 39.4468 79.7795C39.1161 79.7795 38.8019 79.7877 38.992 79.8367C39.575 79.7428 39.666 79.9142 40.3068 79.8938C40.2696 79.8938 40.5383 79.7999 40.65 79.7918C40.5673 79.7999 40.8195 79.8163 40.8856 79.8163C41.0055 79.8122 41.175 79.7836 41.2908 79.7836C41.5554 79.7795 41.6464 79.8244 41.9978 79.8326C42.2789 79.8408 42.7585 79.7999 42.8784 79.8081C43.0066 79.8163 42.527 79.955 43.1472 79.853C43.2547 79.9061 43.5772 79.8857 44.0278 79.7999C44.8092 79.6612 44.3131 79.5714 44.863 79.453C45.5534 79.4448 44.5074 79.6612 44.9457 79.7632C44.7431 79.7999 44.5405 79.8367 44.3379 79.8734C44.9167 80.1591 46.9219 79.8489 48.985 79.2367C49.3489 79.2448 50.1179 79.004 50.4197 79.0285C51.4409 78.6653 51.8461 78.6693 52.8921 78.2204C52.9996 78.2408 53.2807 78.1265 53.4048 78.1306C53.9505 77.8734 54.6989 77.604 54.827 77.5673C54.8973 77.551 55.3562 77.3428 55.4348 77.3142C55.8606 77.1591 56.1004 76.9959 56.5966 76.751C56.6255 76.7387 56.6834 76.7387 56.824 76.6693C57.0844 76.5387 57.2374 76.4489 57.4193 76.3795C57.7914 76.2408 58.2876 75.9101 58.7258 75.6367C58.7837 75.6571 58.9491 75.5265 59.1269 75.4285C59.3129 75.3306 59.4535 75.2979 59.5734 75.2326C59.7718 75.1224 60.2638 74.7999 60.4871 74.6571C60.8757 74.4081 61.1941 74.2163 61.5538 73.9265C62.0458 73.6775 62.7321 73.2204 63.2779 72.8081L64.1709 72.1387C64.2164 72.1061 64.2867 72.0326 64.3321 71.9959C64.5595 71.7918 64.6877 71.7755 64.8944 71.5836C65.0474 71.4408 65.0391 71.4938 65.097 71.4489C65.6345 70.9918 65.7916 70.7755 66.0562 70.5673C66.3415 70.3346 66.296 70.3469 66.4986 70.1102C66.879 69.6653 66.9658 69.6612 67.2676 69.3428C67.5612 69.0367 67.6852 68.8612 67.8795 68.7142C68.0904 68.551 68.4625 68.0204 68.5245 68.0734C68.7767 67.7836 69.0826 67.3591 69.3142 67.0816C69.3514 67.0367 69.6077 66.8204 69.6697 66.7469C69.8392 66.5469 70.0088 66.2571 70.17 66.0653C70.2362 65.9877 70.4346 65.804 70.5132 65.7183C70.6744 65.5346 70.8439 65.302 70.9721 65.1877C71.5633 64.351 72.1091 63.5387 72.6838 62.4734C72.8987 62.1918 73.1592 61.702 73.3329 61.5183C73.6636 60.9346 73.6347 60.8367 73.8497 60.3877C74.1515 60.1142 74.4988 59.2326 74.7758 58.6122C74.999 58.1102 75.2388 57.6489 75.4125 57.204C75.5903 56.7428 75.6771 56.4285 75.8342 55.9999C75.9334 55.7346 75.9665 55.7061 76.0781 55.3795C76.136 55.1959 76.1691 55.2122 76.1856 55.1591C76.2725 54.9142 76.351 54.5959 76.4254 54.3428C76.4585 54.2244 76.5412 54.0816 76.5288 54.1224C76.6446 53.6979 76.6239 53.5102 76.7479 53.1142C76.8926 52.6571 77.0167 52.2448 77.0745 52.0408C77.0911 51.9877 77.1076 51.8857 77.12 51.8326C77.1614 51.6489 77.1945 51.6448 77.2068 51.604C77.3888 50.8857 77.5541 49.7795 77.6947 48.8571C77.918 47.4326 78.1206 46.2775 78.0503 45.4244C78.1288 45.1714 78.1288 44.9101 78.1536 44.5224C78.1784 44.0979 78.2074 43.4285 78.2281 43.1918C78.2942 42.7061 78.2363 41.5673 78.2322 41.2285ZM70.8274 43.3265C70.7281 43.2897 70.8067 42.5714 70.7984 42.1061C71.0341 42.1918 70.9555 41.1387 71.1829 41.2163C71.1995 41.7959 71.0837 41.9428 70.9845 42.1346C70.8853 42.3265 70.8067 42.5632 70.8274 43.3265ZM71.0093 45.2489C71.4269 42.3999 71.4475 39.6612 71.2119 37.1591C71.3814 37.1428 71.493 38.0448 71.5468 38.955C71.6088 39.8652 71.6129 40.7795 71.7824 40.7959C71.6625 41.0448 71.5964 42.2408 71.4848 43.4775C71.3814 44.7142 71.2326 45.9877 71.2574 46.4122C71.431 45.5918 71.5178 46.2204 71.2904 46.6938C71.5964 46.2693 71.7948 45.0163 71.8775 43.6938C71.9685 42.3673 71.9395 40.9836 72.0677 40.2489C72.3695 40.9346 72.2538 40.3061 72.3985 39.3061C72.3861 39.9387 72.3943 40.2408 72.4067 40.5306C72.415 40.8204 72.4315 41.102 72.3861 41.6816C72.291 41.7306 72.2827 41.3306 72.1587 41.5101C72.3406 42.2816 71.9726 43.4816 72.1256 44.0979C72.1752 43.7265 72.3116 43.2244 72.3075 43.6693C72.1793 43.8326 72.2 44.4285 72.2248 44.6612C72.1339 44.6693 72.1008 44.1795 71.985 44.7999C71.9189 45.7061 72.0884 44.6979 72.1173 45.6571C71.861 46.3999 71.952 46.351 71.8734 45.7877C71.7287 46.8448 71.7452 46.9142 71.7783 46.9632C71.8072 47.0122 71.8527 47.0367 71.6625 47.9999C71.4641 47.8163 71.216 48.7795 70.9225 49.9142L70.1576 52.8857C69.492 53.7346 69.2563 54.8408 68.5534 56.3061C68.2144 56.9591 67.8051 57.6816 67.3296 58.4489C67.2056 58.5999 67.1105 58.6979 66.9658 58.8938C66.85 59.053 66.8748 59.0775 66.7797 59.204C66.6309 59.404 66.5523 59.4081 66.3746 59.6612C66.4407 59.5714 66.2877 59.8448 66.3001 59.8163C66.1885 60.0448 65.8784 60.3999 65.6014 60.7183C65.6262 60.8448 65.3037 61.2408 65.2624 61.4163C65.0557 61.6816 64.8448 61.9469 64.6216 62.2122C64.4562 62.1836 65.0557 61.5755 64.6464 61.7265C64.6257 61.6897 64.5513 61.7918 64.4644 61.8612C64.4562 61.8693 64.452 61.8693 64.4479 61.8775C66.5813 59.253 68.0159 56.5959 68.7477 54.6244C69.2976 53.7387 69.9633 52.2653 70.4181 50.7877C70.8811 49.3101 71.1333 47.8448 71.154 47.053L70.9886 47.1306C70.6207 49.3714 69.9591 51.6244 69.0454 53.7918C68.1317 55.9632 66.9617 58.0408 65.6056 59.9632C64.9027 60.9551 64.1544 61.9061 63.3647 62.8081C63.1166 63.0408 62.8065 63.3306 62.3352 63.7306C61.8763 64.1306 60.9336 64.8612 60.6194 65.0938C60.454 65.2204 60.2969 65.3428 60.1398 65.4571C61.2726 64.4367 62.3311 63.355 63.2985 62.2163C65.4815 59.653 67.218 56.8285 68.4955 53.9346C69.7772 51.053 70.5917 48.0938 71.0093 45.2489ZM1.55453 37.1632C1.50491 37.4612 1.5752 38.1632 1.48424 38.2612C1.41809 37.7224 1.38088 37.1265 1.43463 36.702C1.64548 36.6897 1.84807 36.6775 1.84394 37.351C1.8274 37.5265 1.80259 37.6408 1.77365 37.7346C1.78192 37.5591 1.78606 37.3591 1.80259 37.1918C1.74471 36.9918 1.65375 37.0653 1.55453 37.1632ZM58.3868 66.6897C57.7914 67.0693 57.2002 67.4203 56.6669 67.7265C56.3857 67.8857 56.1128 68.0693 55.8234 68.2204C55.6663 68.302 55.4307 68.4204 55.195 68.5265C55.4472 68.3714 55.7035 68.2081 55.9723 68.0408C57.2581 67.2367 58.6597 66.2734 59.7264 65.4734C59.408 65.8734 58.9201 66.2897 58.3868 66.6897ZM51.6352 71.0571C51.23 71.2448 51.2714 71.3428 50.8579 71.5224C50.4941 71.6122 50.1344 71.7183 49.7623 71.8367C50.3783 71.5959 50.9985 71.3306 51.6063 71.0448C51.6145 71.0489 51.627 71.0489 51.6352 71.0571ZM46.7483 72.2775C46.8351 72.3102 46.9757 72.3102 47.1411 72.2897C47.0914 72.3346 46.9509 72.3959 46.7111 72.4489L46.5664 72.3183C46.6325 72.3061 46.6904 72.2938 46.7483 72.2775ZM51.6394 70.6693C51.5691 70.7346 51.2052 70.8816 51.3913 70.8938C51.3169 71.0408 51.4368 70.9795 51.5815 71.0326C50.8703 71.1877 50.2047 71.4326 49.4605 71.7142C49.0719 71.8612 48.6584 72.0163 48.2078 72.1714C48.0879 72.1469 48.001 72.1101 47.9845 72.0571C48.1251 71.9959 48.2326 71.9265 48.278 71.8653C48.6832 71.7591 48.8403 71.7918 49.3199 71.6285C49.353 71.604 49.3943 71.5795 49.4357 71.5469C50.1923 71.2734 50.9117 70.9428 51.5649 70.6326C51.6063 70.6448 51.66 70.653 51.6394 70.6693ZM58.7878 65.6653C57.2912 66.9387 55.6829 68.0612 54.0828 69.0408C53.8596 69.155 53.6446 69.2653 53.4875 69.3428C53.2022 69.4857 53.0161 69.6897 52.7226 69.8244C52.4786 69.9346 52.305 69.9836 52.1396 70.0326C52.2016 70.0489 52.0156 70.1346 52.0404 70.1591C52.0735 70.1918 51.9288 70.2285 51.8998 70.2612C51.8874 70.2734 51.8874 70.2857 51.8874 70.2938C51.627 70.4326 51.3665 70.5714 51.1101 70.702C51.0151 70.5918 50.399 70.7959 49.8409 71.0285C50.0765 70.8897 50.2378 70.755 50.2006 70.6612C50.0228 70.6979 49.8285 70.7469 49.6259 70.7999C49.7458 70.751 49.8615 70.702 49.9814 70.653C49.7334 70.551 49.3571 70.7224 48.9974 70.8775C48.6336 71.0326 48.2904 71.1673 48.1292 71.0122C48.2946 70.9469 48.4062 70.8408 48.0548 70.9591C47.9225 71.1755 47.0749 71.502 46.0992 71.7877C46.2315 71.7877 46.3845 71.7755 46.5498 71.751C46.4961 71.7714 46.4093 71.7959 46.2563 71.8244C45.7808 71.902 45.4666 71.8285 44.7389 71.9428C44.0981 72.0408 43.449 72.1591 43.0645 72.302C43.2753 72.4897 43.9493 72.6326 43.1306 72.853C42.7875 72.8081 42.6056 72.7061 41.7828 72.8204C41.8655 72.9183 42.0391 73.0204 41.8035 73.0979C40.683 73.151 40.8319 73.2938 40.0959 73.3591C39.8148 73.3224 39.5295 73.3102 39.207 73.2816C38.9176 73.2571 38.5621 73.1795 38.1197 73.1836C37.7476 73.1999 37.8344 73.302 37.1729 73.2571C37.2638 73.1469 36.8215 73.1469 36.8421 73.053C37.8633 73.0734 37.9502 72.9795 38.6117 73.0204C38.93 73.0367 38.9424 73.0489 39.207 73.004C39.3352 72.9795 39.4799 72.9755 39.575 72.951C39.7859 72.9999 40.2572 72.9755 40.6293 72.9673C40.7947 72.8571 41.5513 72.751 41.6588 72.6775C41.7456 72.6204 41.6009 72.5632 41.605 72.502C41.9689 72.4448 42.3327 72.3836 42.6924 72.3102C45.1689 71.8204 47.294 71.053 49.3117 70.102C51.3293 69.1428 53.2477 67.9999 55.2694 66.551C55.2529 66.5428 55.2322 66.5387 55.2074 66.5346C55.3645 66.4244 55.5216 66.3142 55.6663 66.2122C56.4023 65.6979 57.1919 65.2 57.8865 64.6775C58.5811 64.1551 59.1806 63.6081 59.5279 63.0448C60.8675 61.9918 62.0789 60.5673 63.0422 59.2244C64.0138 57.8857 64.7497 56.6367 65.3658 55.9387C64.6505 57.1469 64.4231 57.702 64.1544 58.3142C63.836 58.6693 63.6334 58.653 63.282 59.0857C62.4716 60.5306 61.4008 61.6122 61.467 62.0489C62.0747 61.1673 63.0959 60.2122 63.8319 59.351C63.989 59.3836 63.2985 60.1999 63.5631 60.1265C64.0675 59.5102 64.5554 58.7959 64.8159 58.8244C63.3399 61.1795 61.2272 63.6081 58.7878 65.6653ZM62.298 57.3183C62.3724 57.3959 61.9755 57.9265 61.7398 58.2816L61.4752 58.2653C61.8928 57.5142 62.0127 57.6979 62.298 57.3183ZM57.9485 64.253C57.5971 64.5387 57.7377 63.9591 58.486 63.3428C58.6721 63.351 58.4033 63.6408 58.6183 63.6326C58.2586 63.9959 57.8907 64.1346 57.9485 64.253ZM56.088 64.6163C55.2198 65.3102 54.4963 65.7714 54.3516 65.7102C54.6492 65.4775 54.9552 65.2326 55.2611 64.9714C56.026 64.3346 56.7826 63.6244 57.4317 62.9877C57.4607 62.9918 57.5268 62.9673 57.6674 62.8897C58.1346 62.5142 58.0064 62.5061 57.9899 62.4285C58.118 62.2938 58.2462 62.1673 58.3578 62.0489C58.3785 62.0285 58.3951 62.0081 58.4157 61.9877C58.8333 61.7877 58.9325 61.9999 58.8457 62.1469C58.023 62.9346 56.9893 63.9061 56.088 64.6163ZM56.3816 65.3836C55.5878 65.9346 55.5919 66.0938 55.0048 66.5101C55.0213 66.3999 54.8436 66.3755 54.8436 66.2571C54.8394 66.1346 55.0213 65.9346 55.7242 65.4244C55.7986 65.4571 55.4968 65.6693 55.3273 65.8204C55.4761 65.9591 56.3196 65.1306 56.3816 65.3836ZM54.1242 66.9714C53.8637 67.0938 53.6198 67.1918 53.4751 67.1755C53.7355 67.0122 53.9753 66.8571 54.1738 66.7224C54.1159 66.8244 54.0621 66.9224 54.1242 66.9714ZM36.6933 73.1306C36.6437 73.2244 36.6602 73.3387 36.0235 73.302C36.284 73.253 35.9367 73.0734 36.6933 73.1306ZM64.2701 58.8367C64.6546 58.2204 64.8986 58.0244 65.1425 57.8408C65.3823 57.6612 65.6221 57.4938 65.9529 56.9224C65.8619 57.2571 65.5146 57.8163 65.1466 58.2448C64.7745 58.6775 64.3942 58.9795 64.2701 58.8367ZM65.7627 58.1142C66.0397 57.653 66.3291 57.2326 66.3663 57.4122C65.9942 58.0979 65.5932 58.7469 65.2831 59.0693C65.2128 59.0693 65.4857 58.5714 65.7627 58.1142ZM65.3161 56.9795C65.3161 56.9591 65.3244 56.9346 65.3244 56.9142C65.5973 56.4857 65.9735 55.9265 66.3001 55.3673C66.4159 55.6489 65.6758 56.4775 65.3161 56.9795ZM65.4319 56.7387C65.4195 56.702 65.403 56.6857 65.3823 56.6897C65.436 56.5591 65.5187 56.4204 65.618 56.2816C65.589 56.3755 65.5353 56.5142 65.4319 56.7387ZM64.9275 17.9142C64.7125 17.6775 64.7125 17.6612 64.4934 17.5102C64.3859 17.4367 64.2825 17.3387 64.1957 17.2897C64.0799 17.1061 63.7326 16.7959 63.4639 16.5428C63.4474 16.5387 63.4226 16.5306 63.4019 16.5224C63.1249 16.2408 62.8396 15.9673 62.5502 15.6938C62.5543 15.6122 62.5874 15.555 62.728 15.6244C63.5549 16.3673 63.5549 16.1632 64.1171 16.6326C64.2867 16.8571 64.4851 17.0612 64.6918 17.3102C64.8779 17.5306 65.0763 17.8326 65.3906 18.1387C65.6634 18.3877 65.6758 18.253 66.1141 18.751C65.9735 18.7673 66.2836 19.0734 66.2009 19.1306C65.4898 18.3999 65.3616 18.404 64.9275 17.9142ZM56.2989 10.9999C56.5842 11.1428 56.8819 11.2857 57.2002 11.4285C57.3036 11.5101 57.4069 11.6244 57.4896 11.7306C57.0968 11.4816 56.6999 11.2367 56.2989 10.9999ZM67.6686 53.5061C67.4165 54.3795 68.2888 52.8734 68.0821 53.6857C67.801 54.1306 67.5405 54.302 67.3007 54.3755C66.8211 55.4448 67.0319 55.1795 66.4862 56.0816C66.42 55.9346 66.7095 55.3346 66.9369 54.8244C67.1642 54.3142 67.3255 53.8979 67.0733 54.151C67.0857 53.9061 67.2841 53.6285 67.5736 52.7306C67.6273 52.8571 67.6976 52.8571 67.7761 52.7714C67.7968 52.7632 67.8258 52.7469 67.863 52.7142C67.9498 52.5224 67.9953 52.404 68.0159 52.3224C68.0738 52.1877 68.1317 52.0285 68.1896 51.8652C68.4294 51.1795 68.6568 50.3224 68.8925 49.9469C68.7064 50.9999 68.2599 52.3183 67.6686 53.5061ZM67.6273 50.9714C67.094 52.4489 66.4283 53.8652 66.4076 54.5265C65.9983 55.2163 66.2753 54.0489 65.651 55.404C66.0976 54.2367 66.726 52.8938 67.2676 51.4938C67.8134 50.0979 68.2805 48.6408 68.4955 47.3591C68.5824 47.9795 68.1731 49.4979 67.6273 50.9714ZM65.8826 19.3061C65.9942 19.3591 66.1472 19.4816 66.3952 19.7428C66.5027 19.9224 66.6185 20.1632 66.6474 20.3061C66.3952 19.9714 66.143 19.6367 65.8826 19.3061ZM66.3539 19.1755C66.4531 19.1428 66.5275 19.053 66.9493 19.5224C66.7301 19.3755 66.85 19.7469 66.3539 19.1755ZM70.7819 25.1346C70.9514 25.2938 71.3938 26.0367 71.4889 26.3346C71.3607 26.3591 71.1664 26.1714 70.786 25.5265C70.7199 25.3306 70.6992 25.1795 70.7819 25.1346ZM70.3312 15.5387C70.5586 15.7265 70.9804 16.3632 71.0465 16.5959C71.0548 16.8612 70.6496 16.2326 70.2734 15.7265L70.3312 15.5387ZM68.6113 13.5346C68.9875 13.9306 68.8594 13.9428 69.1198 14.2612C69.5664 14.8081 69.6449 14.7224 69.8351 14.8326C69.9426 14.9999 70.0501 15.1673 70.0625 15.253C69.8641 15.404 69.7979 15.7836 69.2025 15.1877C68.785 14.6816 68.9875 14.6693 68.6113 14.2081C68.5162 13.9836 68.1441 13.555 68.1234 13.3959C68.1648 13.2408 68.603 13.7428 68.6113 13.5346ZM45.0325 0.669334C44.524 0.575457 43.9658 0.506069 43.9203 0.375457C44.371 0.45709 45.14 0.522396 45.0325 0.669334ZM28.7097 5.06117C29.3133 4.81627 29.582 4.5877 30.4172 4.44076C30.6363 4.15097 30.4585 3.95097 29.7639 3.88566C30.3552 3.7428 30.0161 3.69791 30.6115 3.56321C30.5412 3.79586 31.3144 3.71015 31.4053 3.84893C31.5252 4.02035 30.9629 4.20811 31.0291 4.35505C31.0704 4.44893 31.1862 4.46933 31.4549 4.53056C32.4513 4.25709 33.5387 4.07342 34.5434 3.89382C35.1015 3.79178 34.9858 3.77138 35.2793 3.78362C35.3248 3.7877 35.5894 3.7428 35.6473 3.73464C35.763 3.7224 35.8871 3.74689 35.8623 3.75097C36.0897 3.72648 36.47 3.64893 36.7553 3.61627C37.2887 3.55505 37.9667 3.52648 38.4298 3.50199C38.6696 3.48974 38.6613 3.45301 38.9631 3.44484C39.5543 3.42444 39.7114 3.48974 39.8975 3.42852C40.0133 3.39178 40.435 3.39995 40.8319 3.4326C41.2288 3.46117 41.5926 3.50607 41.605 3.50607C41.8242 3.51423 41.8696 3.48974 42.1425 3.49382C42.9115 3.5224 43.358 3.64484 43.8459 3.68158C44.2635 3.71423 44.6769 3.67342 45.0904 3.7224L44.9705 3.46525C44.6108 3.35097 44.3503 3.27342 44.3048 3.17546C44.2883 3.1428 44.3007 3.09791 44.4537 3.11423C45.0614 3.20403 45.3384 3.34689 45.6857 3.49382C45.8594 3.56729 45.8015 3.6326 45.9503 3.69791C46.1653 3.79178 46.3638 3.84076 46.7318 3.9224C47.0418 3.95913 46.6325 3.71015 47.017 3.77546C48.2656 4.00811 48.4352 4.28566 49.3241 4.57546C49.4357 4.50199 50.0393 4.67342 50.3618 4.71423C50.4114 4.76729 50.5272 4.80403 50.738 4.87342C51.1598 5.01627 51.1308 5.12648 51.3251 5.23668C53.6652 6.02852 55.6746 6.98362 57.5475 8.08974C59.3708 9.17546 61.0742 10.4163 62.7652 11.9346C62.7362 11.9183 62.7073 11.8979 62.6784 11.8816C61.8473 11.1183 60.5533 10.2122 59.0028 9.35913C58.515 9.09791 58.7589 9.39995 58.271 9.14688C57.9816 8.92239 57.2829 8.59995 56.7206 8.33464C56.4932 8.14688 56.8405 8.1224 55.8689 7.68974C55.6415 7.60811 55.4307 7.54689 55.2942 7.53056C55.3232 7.61627 55.1743 7.5877 54.9345 7.51015C54.7319 7.42852 54.7071 7.45301 54.5459 7.39586C54.182 7.26933 53.9423 7.13056 53.7314 7.04076C53.38 6.88974 53.2849 6.87342 53.1112 6.77546C53.1774 6.64484 52.8011 6.46525 52.5944 6.30199C51.7179 6.01219 51.1225 5.76321 50.0848 5.51831C49.6093 5.42444 49.5887 5.52648 49.1132 5.44076L49.0553 5.30607C48.5054 5.16729 48.6874 5.31831 48.2739 5.25301C47.877 5.19586 47.4057 5.05709 46.7938 4.96729C46.3348 4.80811 46.1447 4.63668 45.7519 4.48158C45.5782 4.44893 45.326 4.42035 45.2971 4.37954C44.4826 4.3428 43.8666 4.16321 43.1679 4.19586C42.5063 4.0326 42.1797 4.11015 41.3818 4.01627C41.0221 4.04076 40.9146 4.11015 40.1456 4.07342C39.7156 4.05709 39.8603 3.91831 39.1905 3.96321C38.93 4.02035 39.2484 4.15505 38.6985 4.17546C38.1155 4.19995 38.2148 4.12648 37.8385 4.21219C37.8096 4.24893 37.7393 4.28974 37.6814 4.32648C37.1646 4.32648 36.6478 4.33872 36.1269 4.35913C36.1269 4.35097 36.1227 4.34689 36.1227 4.33872C36.4039 4.25301 36.1393 4.13464 36.069 4.02444C35.2132 4.15097 34.4359 4.22444 33.7041 4.32648C32.6002 4.4775 31.8601 4.69791 31.5004 4.65709C30.7893 4.80811 30.9174 4.91015 30.4709 5.05301C29.9086 5.16729 29.3464 5.29382 28.7923 5.4326C28.7923 5.40403 28.7262 5.39586 28.5277 5.37954C28.4161 5.41219 28.3003 5.44893 28.1804 5.48566C28.383 5.41219 28.5815 5.34689 28.7799 5.29791C28.9122 5.19178 28.8254 5.1224 28.7097 5.06117ZM26.0967 5.68974C25.9396 5.73464 25.7783 5.78362 25.5427 5.88974C25.4848 5.79587 26.0553 5.57137 26.0967 5.68974ZM24.4801 6.70607L24.9886 6.55097C24.7819 6.63668 24.5793 6.7224 24.4015 6.80811C24.3065 6.85301 24.2444 6.89382 24.1907 6.93056C24.0046 7.00403 23.8186 7.08566 23.6325 7.16321C23.9344 6.99586 24.3271 6.74689 24.4801 6.70607ZM23.31 7.2979C23.2439 7.32648 23.1819 7.35505 23.1157 7.38362C23.1819 7.3428 23.2522 7.30199 23.2852 7.28566C23.3018 7.28158 23.3059 7.28974 23.31 7.2979ZM22.9503 7.45709C22.8139 7.51831 22.6775 7.57954 22.5369 7.64484C22.6692 7.57137 22.7974 7.50199 22.9214 7.44484C22.9338 7.44076 22.9421 7.44893 22.9503 7.45709ZM1.85221 30.7469C1.89355 30.6897 2.05066 29.951 2.08787 30.2571C2.12095 30.3224 2.14989 30.3959 2.1871 30.4489C2.04653 30.8979 1.91422 31.355 1.79019 31.7836C1.67442 31.6326 1.59174 31.3673 1.58347 30.8816C1.74885 30.355 1.76125 30.8653 1.85221 30.7469ZM9.0627 65.4857C8.80223 65.1142 8.3061 64.5306 8.48801 64.502C8.77742 64.9224 9.12058 65.3591 9.0627 65.4857ZM21.2015 72.0612C20.8376 72.1142 20.9782 72.3755 21.4206 72.9101C20.8997 72.5959 21.1849 72.8693 20.6681 72.5469C20.8873 72.4326 20.3167 71.951 20.3498 71.7918C20.3787 71.6326 20.7136 71.751 20.8873 71.7469C21.1891 71.9061 21.1477 72.0326 21.2428 72.0979C21.6563 72.3673 21.71 72.5346 22.5369 72.8204C22.5369 72.8204 22.5369 72.8204 22.5369 72.8244C22.1276 72.5632 21.8961 72.5428 21.2015 72.0612ZM25.4558 74.1959C25.6005 74.2775 25.7494 74.351 25.9933 74.4408C25.9644 74.551 25.3979 74.3102 25.4558 74.1959ZM72.6755 55.8122C72.6879 55.7224 72.6962 55.6326 72.6259 55.6489C72.8367 55.2244 73.0021 54.9346 73.1509 54.7101L73.2956 54.6857C73.213 55.0653 72.8905 55.5183 72.6755 55.8122ZM73.3949 46.8285C73.2874 46.8448 73.184 46.8775 73.0724 47.1101C72.8036 47.8571 72.506 48.7877 72.1545 49.7469C72.1421 49.7836 72.1256 49.8204 72.1132 49.8571C72.4522 48.604 72.7168 47.3673 72.8987 46.1714C72.9732 45.5387 72.6631 46.0857 72.7788 45.2979C73.0021 45.1387 72.8781 45.7714 73.1013 45.1101C74.0647 37.6734 72.5101 29.7795 68.5121 23.102C68.1028 22.4122 67.6604 21.7428 67.2015 21.0857C67.2635 21.0938 67.3338 21.1224 67.4909 21.302C67.8299 21.6448 68.1358 21.9346 68.6154 22.5959C68.4749 22.7102 68.8098 23.2285 68.8139 23.4734C69.1157 23.9591 69.1281 23.8204 69.3886 24.2285C69.5912 24.6571 69.9137 25.2122 70.2734 25.8367C70.4925 26.155 70.6372 26.2857 70.8274 26.5469C70.7943 26.9142 71.3525 27.5306 71.584 28.2204C71.6377 28.0612 71.8321 28.6326 71.9768 28.8367C72.1339 29.0612 72.1628 28.8653 72.3241 29.204C72.4439 29.4571 72.506 29.4285 72.6176 29.6612C72.7871 29.7918 72.4894 28.9632 72.7458 29.4571C72.8946 29.8571 72.9111 30.0734 73.1592 30.6285C73.3453 30.902 73.5685 31.3714 73.7256 31.5346C73.705 31.1918 73.4652 31.0448 73.4693 30.755C73.5479 30.7632 73.5355 30.5632 73.5189 30.3755L73.6264 30.8204C73.6512 30.9755 73.7215 31.1959 73.7835 31.4122C73.7959 31.4693 73.7959 31.5224 73.7959 31.6244C73.7959 31.6857 73.8207 31.8244 73.8497 31.9673C73.8373 32.0204 73.8455 32.1061 73.9034 32.2734C73.9158 32.355 73.9158 32.4081 73.891 32.4122C73.9696 32.9714 74.0647 32.9183 74.1349 33.4816C74.1515 33.6693 74.1349 33.7795 74.1308 33.9142C74.0068 33.6816 73.8042 32.8897 73.6719 32.7101C73.5354 32.6857 73.7835 33.2938 73.6429 33.2693C73.7091 33.4938 73.8125 33.7918 73.7835 33.8652C74.197 34.9142 74.3375 35.6244 74.6559 37.0163C74.6683 37.0408 74.6807 37.0653 74.6931 37.0897C74.7096 37.604 74.7592 38.3714 74.6063 38.151C74.4781 38.1224 74.5277 36.9632 74.3499 37.1591C74.3996 38.1061 74.2466 38.3102 74.2631 39.3183C74.2921 39.3387 74.3045 39.4489 74.2879 39.6775C74.3375 39.7265 74.3499 39.902 74.3913 39.9877C74.4368 40.0816 74.5525 39.7918 74.4946 40.302C74.4326 41.3183 74.3375 40.4326 74.2011 41.0204C74.1763 41.3387 74.1432 41.6571 74.1101 41.9755C74.2838 42.1265 74.3499 41.4489 74.4409 41.0734C74.4698 41.2734 74.4285 41.7306 74.3665 42.204C74.3003 42.2816 74.2548 42.5591 74.1887 42.653C74.2548 42.2734 74.0275 42.4734 74.0316 42.9101C73.8662 43.3061 74.1267 43.3469 74.0605 43.7795C73.8951 44.1999 73.7298 44.7673 73.5437 45.0489C73.4528 45.4897 73.3535 45.9265 73.2502 46.3632C73.2419 46.6652 73.5355 46.2693 73.3949 46.8285Z" fill="#fff"/>
         </g>
      </svg>
   ';

   echo '<div class="service-one__single' . esc_attr($active) . esc_attr($last_style) . '">';
      echo '<div class="service-one__content">';

   		if($image_url){ 
				echo '<div class="service-one__image">';
               echo '<div class="service-one__image-inner">';
   					echo '<img src="' . esc_url($image_url) . '" alt="' . esc_html($item['title']) . '"/>';
   				echo '</div>';
               if($has_icon){
                  echo '<span class="service-one__icon">';
                     Icons_Manager::render_icon( $item['selected_icon'], [ 'aria-hidden' => 'true' ] );
                     echo '<span class="service-one__shape">';
                        echo $svg;
                     echo '</span>';
                  echo '</span>';
               } 
            echo '</div>';
			}

			echo '<div class="service-one__content-inner">';
				
				if($item['title']){
					echo '<h4 class="service-one__title"><span>' . esc_html($item['title']) . '</span></h4>';
				}
				if($item['desc']){
					echo '<div class="service-one__desc">' . $item['desc']  . '</div>';
				}
				
			echo '</div>';

			echo $this->gva_render_link_overlay($item['link'], 'service-one__link-overlay');
			
		echo '</div>';
	echo '</div>';
} 

?>	

<?php
if($settings['style'] == 'style-2'){ 

	$image_id = $item['image']['id']; 
   $image_url = isset($item['image']['url']) ? $item['image']['url'] : '';
   if($image_id){
      $attach_url = Group_Control_Image_Size::get_attachment_image_src($image_id, 'image', $settings);
      if($attach_url){
         $image_url = $attach_url;
      }
   }

   echo '<div class="service-two__single' . esc_attr($active) . '">';
     
      if($image_url){ 
         echo '<div class="service-two__image">';
            echo '<img src="' . esc_url($image_url) . '" alt="' . esc_html($item['title']) . '"/>';
            if($item['title']){
               echo '<h4 class="service-two__title"><span>' . esc_html($item['title']) . '</span></h4>';
            }
         echo '</div>';
      }
      echo '<div class="service-two__content">';
            if($has_icon){
               echo '<span class="service-two__icon">';
                  Icons_Manager::render_icon( $item['selected_icon'], [ 'aria-hidden' => 'true' ] );
               echo '</span>';
            } 
   			if($item['title']){
   				echo '<h4 class="service-two__title"><span>' . esc_html($item['title']) . '</span></h4>';
   			}
   			if($item['desc']){
   				echo '<div class="service-two__desc">' . $item['desc']  . '</div>';
   			}
            if(isset($item['link']['url']) && $item['link']['url']){
                  echo '<div class="service-two__button">';
                     $this->gva_render_link_html_2(esc_html__('Make a Donation', 'welowe-themer'), $item['link'], 'btn-inline'); 
                  echo '</div>';
               }
   		
		echo '</div>';
      echo $this->gva_render_link_overlay($item['link'], 'service-two__link-overlay');
	echo '</div>';
} 	
?>

<?php
if($settings['style'] == 'style-3'){ 

   $image_id = $item['image']['id']; 
   $image_url = isset($item['image']['url']) ? $item['image']['url'] : '';
   if($image_id){
      $attach_url = Group_Control_Image_Size::get_attachment_image_src($image_id, 'image', $settings);
      if($attach_url){
         $image_url = $attach_url;
      }
   }

   echo '<div class="service-three__single' . esc_attr($active) . '">';
      echo '<div class="service-three__content">';
         if($has_icon){
            echo '<span class="service-three__icon">';
               echo '<span class="service-three__icon-inner">';
                  Icons_Manager::render_icon( $item['selected_icon'], [ 'aria-hidden' => 'true' ] );
               echo '</span>';
            echo '</span>';
         } 
         echo '<div class="service-three__content-inner">';
            if($item['title']){
               echo '<h4 class="service-three__title"><span>' . esc_html($item['title']) . '</span></h4>';
            }
            if($item['desc']){
               echo '<div class="service-three__desc">' . $item['desc']  . '</div>';
            }
            if(isset($item['link']['url']) && $item['link']['url']){
               echo '<div class="service-three__button">';
                  $this->gva_render_link_html_2(esc_html__('Read more', 'welowe-themer'), $item['link'], 'btn-theme btn-medium'); 
               echo '</div>';
            }
         echo '</div>';
         if($image_url){ 
            echo '<div class="service-three__image">';
               echo '<img src="' . esc_url($image_url) . '" alt="' . esc_html($item['title']) . '"/>';
            echo '</div>';
         }
         echo $this->gva_render_link_overlay($item['link'], 'service-three__link-overlay');
      echo '</div>';
   echo '</div>';
}  
?>

<?php 
   if($settings['style'] == 'style-4'){
      $image_id = $item['image']['id']; 
      $image_url = isset($item['image']['url']) ? $item['image']['url'] : '';
      if($image_id){
         $attach_url = Group_Control_Image_Size::get_attachment_image_src($image_id, 'image', $settings);
         if($attach_url){
            $image_url = $attach_url;
         }
      }

      echo '<div class="service-four__single' . esc_attr($active) . '">';
         
         if($image_url){ 
            echo '<div class="service-four__image">';
               echo '<img src="' . esc_url($image_url) . '" alt="' . esc_html($item['title']) . '"/>';
            echo '</div>';
         }

         echo '<div class="service-four__content">';
            echo '<div class="service-four__content-inner">';
               if($has_icon){
                  echo '<span class="service-four__icon">';
                     echo '<span class="service-four__icon-inner">';
                        Icons_Manager::render_icon( $item['selected_icon'], [ 'aria-hidden' => 'true' ] );
                     echo '</span>';
                  echo '</span>';
               } 
               if($item['title']){
                  echo '<h4 class="service-four__title"><span>' . esc_html($item['title']) . '</span></h4>';
               }
               if($item['desc']){
                  echo '<div class="service-four__desc">' . $item['desc']  . '</div>';
               }
               if(isset($item['link']['url']) && $item['link']['url']){
                  echo '<div class="service-three__button">';
                     $this->gva_render_link_html_2(esc_html__('Read more', 'welowe-themer'), $item['link'], 'btn-inline'); 
                  echo '</div>';
               }
            echo '</div>';
         echo '</div>';

         echo $this->gva_render_link_overlay($item['link'], 'service-four__overlay-link');
        
   	echo '</div>';
   }
?>